----------------------------------------------------------------------
--                   G U I L E . B O O L E A N S                    --
--                                                                  --
--    Private package for use in implementing boolean functions.    --
--                                                                  --
--                             B o d y                              --
--                                                                  --
--   This file is part of GARBLE, the Guile/Ada Rich Binding for    --
--     Language Extension, a binding for Ada 2005 to Guile, the     --
--        GNU Ubiquitous Intelligent Language for Extension.        --
--                                                                  --
--                    Copyright © 2010 Atom X                       --
--                                                                  --
-- This library is free software; you can redistribute it and/or    --
-- modify it under the terms of the GNU General Public License as   --
-- published by the Free Software Foundation, version 3 of the      --
-- License, or (at your option) any later version.                  --
--                                                                  --
-- This program is distributed in the hope that it will be useful,  --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of   --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU --
-- General Public License for more details.                         --
--                                                                  --
-- You should have received a copy of the GNU General Public        --
-- License along with this library. If not, see                     --
-- <http://www.gnu.org/licenses/>                                   --
----------------------------------------------------------------------

with Interfaces.C;

package body Guile.Booleans is

   package C renames Interfaces.C;

   use type C.Int;

   function To_Scheme (B : Boolean) return SCM is

      function Internal (Val : C.Int) return SCM;
      pragma Import (C, Internal, "scm_from_bool");

   begin
      if B then
         return Internal (1);
      else
         return Internal (0);
      end if;
   end To_Scheme;

   function To_Ada (B : SCM) return Boolean is

      function Internal (Val : SCM) return C.Int;
      pragma Import (C, Internal, "scm_to_bool");

   begin
      if Internal (B) = 0 then
         return False;
      else
         return True;
      end if;
   end To_Ada;

end Guile.Booleans;
