----------------------------------------------------------------------
--                       G U I L E . I N I T                        --
--                                                                  --
-- Initialization functions of the Guile extension language library --
--                                                                  --
--                             S p e c                              --
--                                                                  --
--                    Copyright © 2010 Atom X                       --
--                                                                  --
-- This library is free software; you can redistribute it and/or    --
-- modify it under the terms of the GNU General Public License as   --
-- published by the Free Software Foundation, version 3 of the      --
-- License, or (at your option) any later version.                  --
--                                                                  --
-- This program is distributed in the hope that it will be useful,  --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of   --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU --
-- General Public License for more details.                         --
--                                                                  --
-- You should have received a copy of the GNU General Public        --
-- License along with this library. If not, see                     --
-- <http://www.gnu.org/licenses/>                                   --
----------------------------------------------------------------------

package Guile.Init is

   generic
      type Data_Type is (<>);
      type Return_Type is (<>);
   package With_Guile is

      type Caller_Func is
        access function (Data : Data_Type) return Return_Type;
      pragma Convention (C, Caller_Func);

      function Call (Func : Caller_Func;
                     Data : Data_Type) return Return_Type;
      pragma Import (C, Call, "scm_with_guile");
   end With_Guile;


   procedure Init;
   procedure Shell;


private
   pragma Import (C, Init, "scm_init_guile");

   --  No binding: scm_boot_guile
   --    Would put the burden on the user of this binding to handle
   --    C-style (int argc, char **argv)-style command-line options
end Guile.Init;
